#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include "cvect.h"

cvect::cvect(int dim) {
  dimensions = dim;
  values = new double[dim];
  assert(values != NULL);
  for (int n = 0; n < dim; n++)
    values[n] = 0;
}

cvect::cvect(cvect& cv) {
  dimensions = cv.dim();
  values = new double[dimensions];
  assert(values != NULL);
  for (int n = 0; n < dimensions; n++)
    values[n] = cv[n];
}

int cvect::dim(void) {
  return dimensions;
}

cvect& cvect::operator=(cvect rval) {
  assert(dimensions == rval.dim());
  for (int n = 0; n < dimensions; n++)
    values[n] = rval[n];
  return *this;
}

cvect cvect::operator+(cvect& rval) {
  assert(dimensions == rval.dim());
  cvect ret(rval.dim());
  for (int n = 0; n < dimensions; n++)
    ret[n] = values[n] + rval[n];
  return ret;
}

cvect cvect::operator-(cvect& rval) {
  assert(dimensions == rval.dim());
  cvect ret(rval.dim());
  for (int n = 0; n < dimensions; n++)
    ret[n] = values[n] - rval[n];
  return ret;
}

cvect cvect::operator*(double rval) {
  cvect ret(dimensions);
  for (int n = 0; n < dimensions; n++)
    ret[n] = values[n] * rval;
  return ret;
}

cvect cvect::operator/(double rval) {
  assert (rval != 0);
  cvect ret(dimensions);
  for (int n = 0; n < dimensions; n++)
    ret[n] = values[n] / rval;
  return ret;
}

bool cvect::operator==(cvect& rval) {
  if (dimensions != rval.dim())
    return false;
  bool ret = true;
  for (int n = 0; n < dimensions && ret; n++)
    ret = (values[n] == rval[n]);
  return ret;
}

bool cvect::operator!=(cvect& rval) {
  if (dimensions != rval.dim())
    return true;
  bool ret = true;
  for (int n = 0; n < dimensions && ret; n++)
    ret = (values[n] == rval[n]);
  return !ret;
}

double& cvect::operator[](int index) {
  assert (index < dimensions);
  return values[index];
}

double cvect::length(void) {
  double sum = 0;
  for (int n = 0; n < dimensions; n++)
    sum += values[n] * values[n];
  return sqrt(sum);
}

cvect cvect::cross(cvect& rval) {
  assert (dimensions == rval.dim());
  assert (rval.dim() == 3);
  cvect ret(dimensions);
  ret[0] = values[1] * rval[2] - values[2] * rval[1];
  ret[1] = values[2] * rval[0] - values[0] * rval[2];
  ret[2] = values[0] * rval[1] - values[1] * rval[0];
  return ret;
}

double cvect::dot(cvect& rval) {
  assert (dimensions == rval.dim());
  double sum = 0;
  for (int n = 0; n < dimensions; n++)
    sum += values[n] * rval[n];
  return sum;
}

cvect cvect::unit(void) {
  return operator/(length());
}

void cvect::print(void) {
  printf("|<%f,%f,%f>| = %f\n",values[0],values[1],values[2],length());
}

cvect::~cvect(void) {
  delete[] values;
}

cvect operator*(double lval, cvect& rval) {
  cvect ret(rval.dim());
  for (int n = 0; n < rval.dim(); n++)
    ret[n] = rval[n] * ((double) lval);
  return ret;
}

cvect operator/(double lval, cvect& rval) {
  cvect ret(rval.dim());
  for (int n = 0; n < rval.dim(); n++) {
    assert (rval[n] != 0);
    ret[n] = lval / rval[n];
  }
  return ret;
}
